<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PinjamanModel extends CI_Model {
	public function get_user()
	{
		$this->load->database();
		$users = $this->db->get('users');
		return $users;
	}

	public function login($username, $password)
	{
		$this->load->database();
		$this->db->select('id, username, status, is_approved');
		$this->db->where('username', $username);
		$this->db->where('password', $password);
		$this->db->limit(1);
		$query=$this->db->get('users');

		if($query->num_rows() == 1)
		{
			return $query->result();
		}
		else
		{
			$this->session->set_flashdata('error', 'error username or password');
		}
	}

	public function signup($data)
	{
		$this->load->database();

		$users = $this->db->get('users');
		if($users->num_rows() == 0)
		{
			$query = $this->db->insert('users',$data);
			if($query)
			{
				$this->session->set_flashdata('successful', 'Your registration was successful. Now, you become an administrator.');
			}
			else
			{
				$this->session->set_flashdata('error', 'Something wrong.');
			}
		}
		else if($users->num_rows() < 7 && $users->num_rows() != 0)
		{
			$query = $this->db->insert('users',$data);
		
			if($query)
			{
				$this->session->set_flashdata('success', 'Your registration was successful. Please wait for admin approval.');
			}
			else
			{
				$this->session->set_flashdata('error', 'Something wrong.');
			}
		}
		else
		{
			$this->session->set_flashdata('', 'Database full. Cannot register anymore');
		}		
	}

	public function get_complete($search)
	{
		$this->load->database();
		$this->db->like('nim', $search, 'BOTH');
		$this->db->order_by('nim', 'ASC');
		$this->db->limit(10);
		return $this->db->get('mahasiswa')->result();
	}

	public function search($search)
	{
		// $this->db->where('m.kode_prodi = f.kode_prodi');
		$this->db->where('m.nim', $search);
		$this->db->where('m.kode_prodi = f.kode_prodi');
		return $this->db->get('mahasiswa as m, fakultas_prodi as f')->result();
	}

	public function registrasi($nama, $nim, $fakultas, $programstudi, $ipk, $nohp, $nohportu, $persyaratan1, $persyaratan2, $persyaratan3, $persyaratan4, $pengajuanpinjaman, $wd3, $catatan)
	{
		$this -> load -> database();
		$this -> db -> select('nama, nim, fakultas, programstudi, ipk, nohp, nohportu, persyaratan1, persyaratan2, persyaratan3, persyaratan4, pengajuanpinjaman, wd3, catatan');
		$this -> db -> from('users');
		$this -> db -> where('nama', $nama);
		$this -> db -> where('nim', $nim);
		$this -> db -> where('fakultas', $fakultas);
		$this -> db -> where('program_studi', $programstudi);
		$this -> db -> where('ipk', $ipk);
		$this -> db -> where('no_hp', $nohp);
		$this -> db -> where('no_hp_ortu', $nohportu);
		$this -> db -> where('ktm', $persyaratan1);
		$this -> db -> where('khs', $persyaratan2);
		$this -> db -> where('invoice', $persyaratan3);
		$this -> db -> where('transkrip_nilai', $persyaratan4);
		$this -> db -> where('pengajuan_pinjaman', $pengajuanpinjaman);
		$this -> db -> where('persetujuan_pinjaman', $wd3);
		$this -> db -> where('catatan', $catatan);
		$this -> db -> limit(1);

		$query = $this -> db -> get();

		if($query -> num_rows() == 1)
		{
			return $query -> result();
		}
		else
		{
			return false;
		}
	}

	public function getNonAuthorized()
	{
		$this->load->database();
		$this->db->where('is_approved', 0);
		$users = $this->db->get('users');
		return $users;
	}

	public function getAuthorized()
	{
		$this->load->database();
		$this->db->where('is_approved', 1);
		$this->db->where('id!=', 1);
		$users = $this->db->get('users');
		return $users;
	}

	public function authorize($param1 = '')
	{
		$this->load->database();
		$data = array(
			'is_approved'=>1
		);
		$this->db->where('id', $param1);
		$query = $this->db->update('users', $data);
		if($query)
		{
			$this->session->set_flashdata('updatesuccess', 'User approval successful');
		}
		else
		{
			$this->session->set_flashdata('error', 'Something wrong.');
		}
	}

	public function delete($param1 = '')
	{
		$this->load->database();
		$this->db->where('id', $param1);
		$query = $this->db->delete('users');
		if($query)
		{
			$this->session->set_flashdata('deletesuccess', 'Delete user successful');
		}
		else
		{
			$this->session->set_flashdata('error', 'Something wrong.');
		}
	}


function inserttodatabase($data)
 {
  return $this->db->insert_batch('mahasiswa', $data);
 }

function getData2($id){
	$this->db->where('m.nim', $id);
	$this->db->where('m.kode_prodi = f.kode_prodi');
	//$this->db->where('p.nim = m.nim');
	$this->db->from('mahasiswa as m, fakultas_prodi as f');
	return $this->db->get()->result();
}

function getData3($id){
	$this->db->where('m.nim', $id);
	$this->db->where('m.kode_prodi = f.kode_prodi');
	$this->db->where('p.nim = m.nim');
	$this->db->from('mahasiswa as m, fakultas_prodi as f, pengajuan as p');
	return $this->db->get()->result();
}

function insertPengajuan($data, $data2, $id){
$this->db->insert('pengajuan', $data);

$this->db->where('m.nim', $id);
$this->db->update('mahasiswa as m', $data2);
}

function updatePengajuan($id, $data){
	$this->db->where("nim", $id);
	return $this->db->update('pengajuan', $data);
}

function deletePengajuan($id){
	$this->db->where("nim", $id);
	$this->db->delete('pengajuan');

	$this->db->set("validasi", 0);
	$this->db->set("status_peminjaman", 0);
	$this->db->where("nim", $id);
	$this->db->update('mahasiswa');
}

function getData4(){
	$this->db->where('m.status_peminjaman', 1);
	$this->db->where('m.kode_prodi = f.kode_prodi');
	$this->db->where('p.nim = m.nim');
	$this->db->from('mahasiswa as m, fakultas_prodi as f, pengajuan as p');
	return $this->db->get()->result();
}


function data($number,$offset)
{
	$this->db->where('m.status_peminjaman', 1);
	$this->db->where('m.kode_prodi = f.kode_prodi');
	$this->db->where('p.nim = m.nim');
	return $query = $this->db->get('mahasiswa as m, fakultas_prodi as f, pengajuan as p',$number,$offset)->result();		
}


function jumlah_data()
{
	$this->db->where('m.status_peminjaman', 1);
	$this->db->where('m.kode_prodi = f.kode_prodi');
	$this->db->where('p.nim = m.nim');
	return $this->db->get('mahasiswa as m, fakultas_prodi as f, pengajuan as p')->num_rows();
}

function getSisa($id){
	$this->db->select('*');
	$this->db->where('p.nim', $id);
	return $this->db->get('pengajuan as p')->result();
}

function hitungCicilan($id, $cicilan){
	$this->db->set("dana_sisa", "dana_sisa-'$cicilan'", FALSE);
	$this->db->where('nim', $id);
	$this->db->update('pengajuan');
}

function tambahHistoriCicilan($data){
	  return $this->db->insert('history', $data);
}

function getHistori($id){
	$this->db->where('nim', $id);
	return $this->db->get('history')->result();
}

function deleteCicilan($id){
	$this->db->where('id', $id);
	$this->db->delete('history');
}
}
?>